Hallo liebe Leute,

nachfolgend habe ich die wichtigsten Passagen des Turbo Pascal Quelltextes von Tausim
zusammengestellt. Dies sind

- allgemeine Berechnung der Gewebesaettigung
- Berechnung der Flugverbotszeit
- Berechnung der Entsaettigungszeit
- Berechnung eines Aufstiegsprofiles

Ich hoffe, diese Zusammenstellung hilft Euch ein wenig, wenn Ihr selbst Euer
Deko-Programm schreiben wollt !

Falls Ihr noch Fragen habt, dann schickt mir doch einfach eine Mail an
<kai_schroeder@gmx.net> !

Viel Spass

         Kai


--------------------------------------------------------------------------------

allgemeine Berechnung der Gewebesaettigung:
-------------------------------------------

He-Gleichungen sind auskommentiert !

Variablennamen habe ich versucht, moeglichst in Anlehnung an das Buehlmann-Buch
zu vergeben.

Ein paar verwendete Konstanten und Felder :

    p_0 = 1.013;           (* Luftdruck in Meereshoehe [bar] *)
    konst = -0.0001251;    (* [m^(-1)] (fuer barometrische Hoehenformal benoetigt) *)
    p_h2o = 0.0627;        (* Gehalt an Wasserdampf im Atemgas bei Einatmung bei 37 Grad C *)
    log2 = 0.69314718056;  (* ln (2) *)
    konst_null = -50000.0; (* Hauptsache kleiner 0 und Betrag sehr gross *)
    anzahl_beruecksichtigte_gewebe = 16;


    (* Koeffizienten des Modells ZH-L16 fuer N2 *)
    zh_l16 : array [1..16, 1..8] of double =

      (* t1/2 N2   ZH-L16A theoretisch    ZH-L16B     ZH-L16   t1/2 He                     *)
      (*           -------------------    Tabelle    Computer                              *)
      (*  [min]       b           a          a           a      [min]       b          a   *)

    (
      (   4.0,     0.5050,      1.2599,    1.2599,    1.2599,    1.51,    0.4245,    1.7424),
      (   8.0,     0.6514,      1.0000,    1.0000,    1.0000,    3.02,    0.5747,    1.3830),
      (  12.5,     0.7222,      0.8618,    0.8618,    0.8618,    4.72,    0.6527,    1.1919),
      (  18.5,     0.7825,      0.7562,    0.7562,    0.7562,    6.99,    0.7223,    1.0458),
      (  27.0,     0.8126,      0.6667,    0.6667,    0.6200,   10.21,    0.7582,    0.9220),
      (  38.3,     0.8434,      0.5933,    0.5600,    0.5043,   14.48,    0.7957,    0.8205),
      (  54.3,     0.8693,      0.5282,    0.4947,    0.4410,   20.53,    0.8279,    0.7305),
      (  77.0,     0.8910,      0.4701,    0.4500,    0.4000,   29.11,    0.8553,    0.6502),
      ( 109.0,     0.9092,      0.4187,    0.4187,    0.3750,   41.20,    0.8757,    0.5950),
      ( 146.0,     0.9222,      0.3798,    0.3798,    0.3500,   55.19,    0.8903,    0.5545),
      ( 187.0,     0.9319,      0.3497,    0.3497,    0.3295,   70.69,    0.8997,    0.5333),
      ( 239.0,     0.9403,      0.3223,    0.3223,    0.3065,   90.34,    0.9073,    0.5189),
      ( 305.0,     0.9477,      0.2971,    0.2850,    0.2835,  115.29,    0.9122,    0.5181),
      ( 390.0,     0.9544,      0.2737,    0.2737,    0.2610,  147.42,    0.9171,    0.5176),
      ( 498.0,     0.9602,      0.2523,    0.2523,    0.2480,  188.24,    0.9217,    0.5172),
      ( 635.0,     0.9653,      0.2327,    0.2327,    0.2327,  240.03,    0.9267,    0.5119)  );

    (* vorgesehene Tiefen fuer notwendige Deko-Stopps *)
    (* (20m bis 90m von mir willkuerlich fuer sehr grosse Tiefen eingefuehrt) *)
    dekostopp_tiefen : array [1..2, 1..13] of byte =

        (*         0m - 700m         *)
      ( (0, 0, 3, 6, 9, 12, 15, 20, 30, 40, 50, 70, 90),

        (*     ab 701 m aufwaerts     *)
        (0, 2, 4, 6, 9, 12, 15, 20, 30, 40, 50, 70, 90) );



  function p_t_tol_ig_naechst_hoehere_dekostufe (var index : word;
                                                 var     j : integer;
                                                 dekostufe : integer) : double;

  var p2, t1, t2 : double;

    begin
      p := dichte * dekostopp_tiefen [j, dekostufe] / 10.0 + p_atm_einstiegshoehe;

      (* gemittelter Koeffizient a *)
      t1 := zh_l16 [index, modell] * p_t_ig_te2_n2;
      t2 := zh_l16 [index, 8] * p_t_ig_te2_he;
      p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
      zh_l16_a := (t1 + t2) / p_t_ig_te2;

      (* gemittelter Koeffizient b *)
      t1 := zh_l16 [index, 2] * p_t_ig_te2_n2;
      t2 := zh_l16 [index, 7] * p_t_ig_te2_he;
      zh_l16_b := (t1 + t2) / p_t_ig_te2;

      p_t_tol_ig_naechst_hoehere_dekostufe := p / zh_l16_b + zh_l16_a
    end; (* p_t_tol_ig_naechst_hoehere_dekostufe *)

  procedure dekostopp_berechnen;

    var
      t1, t2 : double;

    begin
      (* noch tolerierten niedrigeren Umgebungsdruck aller Gewebe bei *)
      (* der momentanen Saettigung des jeweiligen Gewebes berechnen *)
      for i := 1 to anzahl_beruecksichtigte_gewebe do
        begin
          (* gemittelter Koeffizient a *)
          t1 := zh_l16 [i, modell] * p_t_ig_te2_n2;
          t2 := zh_l16 [i, 8] * p_t_ig_te2_he;
          p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
          zh_l16_a := (t1 + t2) / p_t_ig_te2;

          (* gemittelter Koeffizient b *)
          t1 := zh_l16 [i, 2] * p_t_ig_te2_n2;
          t2 := zh_l16 [i, 7] * p_t_ig_te2_he;
          zh_l16_b := (t1 + t2) / p_t_ig_te2;

          p_amb_tol [i] := (p_t_ig_te_hilfe [i] - zh_l16_a) * zh_l16_b
        end;

      (* maximalen Wert (= tiefste Tiefe) bestimmen (Fuehrungsgewebe) *)
      index := 1;
      max_p_amb_tol := p_amb_tol [index];
      for i := 2 to anzahl_beruecksichtigte_gewebe do
        if max_p_amb_tol < p_amb_tol [i]
          then
            begin
              max_p_amb_tol := p_amb_tol [i];
              index := i
            end;

      (* passende Deko-Stufe dazu ermitteln *)

      (* fue max. Wert tolerierte Tiefe bestimmen *)
      tol_tiefe := (max_p_amb_tol - p_atm_einstiegshoehe) * 10.0 / dichte;

      (* Tiefe des notwendigen Deko-Stopps bestimmen *)
      (* (ab 701 m wegen groesserer Sicherheit in geringer Tauchtiefe *)
      (* "Bergsee-Dekostopp-Tiefen" anzeigen) *)
      if hoehe_einstieg <= 700 then j := 1
                               else j := 2;
      i := 1;
      while tol_tiefe > dekostopp_tiefen [j, i] do inc (i);
      erlaubte_tiefe := dekostopp_tiefen [j, i];

      (* notwendige Deko-Zeit auf dieser Tiefe berechnen *)
      p := dichte * erlaubte_tiefe / 10.0 + p_atm_einstiegshoehe;

      t1 := p - p_h2o;
      p_i_ig_n2 := t1 * f_n2;
      p_i_ig_he := t1 * f_he;
      p_i_ig := p_i_ig_n2 + p_i_ig_he;

      zaehler := p_i_ig - p_t_tol_ig_naechst_hoehere_dekostufe (index, j, i - 1);
      nenner := p_i_ig - p_t_ig_te_hilfe [index];
      if nenner = 0.0 then nenner := 1e-20;
      zn := zaehler / nenner;
      if zn > 0.0
        then
          begin
            log := ln (zn);

            (* Mittelwert der Halbwertszeit *)
            t1 := zh_l16 [i, 1] * p_t_ig_te2_n2;
            t2 := zh_l16 [i, 6] * p_t_ig_te2_he;
            p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
            zh_l16_t12 := (t1 + t2) / p_t_ig_te2;

            dekozeit := - zh_l16_t12 * log / log2 + 1.0
            (* 1.0 wird addiert, weil spaeter auf volle Minuten abgeschnitten *)
            (* wird und so sichergestellt wird, dass mindestens 1 Minute *)
            (* dekomprimiert wird *)
          end
        else
          begin
            dekozeit := -1.0       (* egal, Hauptsache negativ *)
            (* Fehler, das sollte hoffentlich nie der Fall sein ! *)
          end;

      if dekozeit > 0.0
        then
          begin
            (* Regelfall *)

            dekostopp := true;

            (* Dekostopp-Anzeige *)
            <Ausgabe von Tiefe und Zeit fuer diese Dekostufe>

            if (dekostopp_tiefen [j, i] > tiefe)
              then
                (* Dekostopp (-tiefe) missachtet *)
                if not dekowarnung_ausgegeben
                  then
                    <Dekowarnung ausgeben>
                  else
                    (* Tiefe noch immer zu wenig tief *)
                    <Warnsignal ausgeben>
              else
                (* Aufstiegsgeschwindigkeit in Ordnung *)
                begin
                  if dekowarnung_ausgegeben
                    then
                      <Dekowarnung loeschen>
                end
          end
        else
          (* nahe der Wasseroberflaeche "unendliche" Nullzeit *)
          unendliche_nullzeit_setzen
    end; (* dekostopp_berechnen *)

  procedure gewebesaettigung_berechnen;

    var
      g, k_n2, k_he, k1_n2, k1_he, r_n2, r_he, t_e_t12_n2, t_e_t12_he,
      t1, t2, t3, t4, t5, t6 : double;

    begin
      saettigung_in_proz_voriges_gewebe := 0.0;

      schritte := 1; (* vorbelegt fuer nur 1 Schritt (wenn tiefe = tiefe_alt); *)
                     (* wenn Aladin-TG nachgerechnet wird, reicht 1 Schritt *)
                     (* immer, da ja alle 20 Sekunden gespeichert wird *)

      (* Start-Umgebungsdruck [bar] (zu Beginn der Exposition) *)
      p_amb0 := dichte * tiefe_alt / 10.0 + p_atm_einstiegshoehe;

      (* momentaner Umgebungsdruck [bar] (am Ende der Exposition) *)
      p_amb := dichte * tiefe / 10.0 + p_atm_einstiegshoehe;

      (* Expositionszeit *)
      t_e := dauer - dauer_alt;
      t_e_hilfe := t_e

      (* N2- und He-Teildruck im Atemgas zu Beginn der Exposition *)
      t1 := p_amb0 - p_h2o;
      p_i_ig0_n2 := t1 * f_n2;
      p_i_ig0_he := t1 * f_he;

      (* N2- und He-Teildruck im Atemgas am Ende der Exposition *)
      t1 := p_amb - p_h2o;
      p_i_ig_n2 := t1 * f_n2;
      p_i_ig_he := t1 * f_he;
      p_i_ig := p_i_ig_n2 + p_i_ig_he;

      (* Schleife ueber alle Gewebe *)
      for i := 1 to anzahl_beruecksichtigte_gewebe do
        begin
          (* Inertgasdruck im i-ten Gewebe zu Beginn der Exposition *)
          p_t_ig_t0 := p_t_ig_te [i];

          if (tiefe <> tiefe_alt)
            then
              begin
                (* Schreiner-Gleichung *)

                (* Quotient aus ln 2 und Halbwertszeit des i-ten Gewebes *)
                k_n2 := log2 / zh_l16 [i, 1];
                k_he := log2 / zh_l16 [i, 6];
                k1_n2 := 1.0 / k_n2;              (* Hilfsgroessee *)
                k1_he := 1.0 / k_he;              (*       "       *)

                (* Ab-/Aufstiegsgeschwindigkeit multipliziert mit dem Inertgasanteil *)
                g := (tiefe - tiefe_alt) / t_e / 10.0;
                                              (* ==== *)
                                              (* wegen Einheit bar/min *)
                   (* ================= *)
                   (* Abstieg => pos. Zahlenwert *)
                r_n2 := g * f_n2;
                r_he := g * f_he;

                (* Druckausgleich der Inertgase des i-ten Gewebes *)
                (* Inertgasdruck am Ende der Exposition nach der *)
                (* Schreiner-Gleichung fuer N2 *)
                t1 := - k_n2 * t_e;
                t2 := exp (t1);
                t3 := r_n2 * k1_n2;
                t4 := p_i_ig0_n2 - p_t_ig_t0 - t3;
                t5 := t2 * t4;
                t6 := (t_e - k1_n2) * r_n2;
                p_t_ig_te2_n2 := p_i_ig0_n2 + t6 - t5;

                (* Schreiner-Gleichung fuer Helium *)
(*                t1 := - k_he * t_e;
                t2 := exp (t1);
                t3 := r_he * k1_he;
                t4 := p_i_ig0_he - p_t_ig_t0 - t3;
                t5 := t2 * t4;
                t6 := (t_e - k1_he) * r_he;
                p_t_ig_te2_he := p_i_ig0_he + t6 - t5; *)
                p_t_ig_te2_he := 0.0;

                (* gemittelter Koeffizient a *)
                t1 := zh_l16 [i, modell] * p_t_ig_te2_n2;
                t2 := zh_l16 [i, 8] * p_t_ig_te2_he;
                p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
                zh_l16_a := (t1 + t2) / p_t_ig_te2;

                (* gemittelter Koeffizient b *)
                t1 := zh_l16 [i, 2] * p_t_ig_te2_n2;
                t2 := zh_l16 [i, 7] * p_t_ig_te2_he;
                zh_l16_b := (t1 + t2) / p_t_ig_te2;

                (* tolerierter Inertgasueberdruck des i-ten Gewebes *)
                p_t_tol_ig [i] := p_amb / zh_l16_b + zh_l16_a;

                (* Saettigung des i-ten Gewebes in Prozent des tolerierten Wertes *)
                saettigung_in_proz := p_t_ig_te2 / p_t_tol_ig [i];

                (* Saettigung des i-ten Gewebes in Prozent bezogen auf die momentane Tiefe *)
                saettigung_in_proz_tiefe := p_t_ig_te2 / p_i_ig;

                if saettigung_in_proz_tiefe > 1.0
                  then
                    (* Gewebe entsaettigt sich *)
                    (* Bedingt durch RLS geht das aber langsamer als gerade *)
                    (* berechnet; deshalb muessen die Gewebesaettigungsdaten *)
                    (* jetzt noch einmal neu berechnet werden *)
                    begin
                      (* Rechts-links-Shunt beruecksichtigen (langsamere N2-Abgabe) *)
                      k_n2 := log2 / zh_l16 [i, 1] / rls;
                      k_he := log2 / zh_l16 [i, 6] / rls;
                      k1_n2 := 1.0 / k_n2;
                      k1_he := 1.0 / k_he;
                      t1 := - k_n2 * t_e;
                      t2 := exp (t1);
                      t3 := r_n2 * k1_n2;
                      t4 := p_i_ig0_n2 - p_t_ig_t0 - t3;
                      t5 := t2 * t4;
                      t6 := (t_e - k1_n2) * r_n2;
                      p_t_ig_te2_n2 := p_i_ig0_n2 + t6 - t5;
(*                      t1 := - k_he * t_e;
                      t2 := exp (t1);
                      t3 := r_he * k1_he;
                      t4 := p_i_ig0_he - p_t_ig_t0 - t3;
                      t5 := t2 * t4;
                      t6 := (t_e - k1_he) * r_he;
                      p_t_ig_te2_he := p_i_ig0_he + t6 - t5; *)
                      p_t_ig_te2_he := 0.0;
                      t1 := zh_l16 [i, modell] * p_t_ig_te2_n2;
                      t2 := zh_l16 [i, 8] * p_t_ig_te2_he;
                      p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
                      zh_l16_a := (t1 + t2) / p_t_ig_te2;
                      t1 := zh_l16 [i, 2] * p_t_ig_te2_n2;
                      t2 := zh_l16 [i, 7] * p_t_ig_te2_he;
                      zh_l16_b := (t1 + t2) / p_t_ig_te2;
                      p_t_tol_ig [i] := p_amb / zh_l16_b + zh_l16_a;
                      saettigung_in_proz := p_t_ig_te2 / p_t_tol_ig [i];
                      saettigung_in_proz_tiefe := p_t_ig_te2 / p_i_ig
                    end
              end
            else
              begin
                (* "Buehlmanns" Form der Gleichung fuer konstanten Druck *)

                (* Quotient aus Expositionszeit und Halbwertszeit des i-ten Gewebes *)
                t_e_t12_n2 := t_e_hilfe / zh_l16 [i, 1];
                t_e_t12_he := t_e_hilfe / zh_l16 [i, 6];

                (* Druckausgleich der Inertgase des i-ten Gewebes *)
                (* Inertgasdruck am Ende der Exposition (des Zeitschritts) *)
                  (* ehemals verwendete Gleichung aus Buehlmann-Buch : *)
                  (* p_t_ig_te2 := (1.0 - exp (- t_e_t12 * log2)) * (p_i_ig - p_t_ig_t0) + p_t_ig_t0; *)
                (* fuer N2 *)
                t1 := - t_e_t12_n2 * log2;
                t2 := 1.0 - exp (t1);
                t3 := p_i_ig_n2 - p_t_ig_t0;
                p_t_ig_te2_n2 := t2 * t3 + p_t_ig_t0;

                (* fuer Helium *)
(*                t1 := - t_e_t12_he * log2;
                t2 := 1.0 - exp (t1);
                t3 := p_i_ig_he - p_t_ig_t0;
                p_t_ig_te2_he := t2 * t3 + p_t_ig_t0; *)
                p_t_ig_te2_he := 0.0;

                (* gemittelter Koeffizient a *)
                t1 := zh_l16 [i, modell] * p_t_ig_te2_n2;
                t2 := zh_l16 [i, 8] * p_t_ig_te2_he;
                p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
                zh_l16_a := (t1 + t2) / p_t_ig_te2;

                (* gemittelter Koeffizient b *)
                t1 := zh_l16 [i, 2] * p_t_ig_te2_n2;
                t2 := zh_l16 [i, 7] * p_t_ig_te2_he;
                zh_l16_b := (t1 + t2) / p_t_ig_te2;

                (* tolerierter Inertgasueberdruck des i-ten Gewebes *)
                p_t_tol_ig [i] := p_amb / zh_l16_b + zh_l16_a;

                (* Saettigung des i-ten Gewebes in Prozent des tolerierten Wertes *)
                saettigung_in_proz := p_t_ig_te2 / p_t_tol_ig [i];

                (* Saettigung des i-ten Gewebes in Prozent bezogen auf die momentane Tiefe *)
                saettigung_in_proz_tiefe := p_t_ig_te2 / p_i_ig
              end;

          (* neuen Inertgasdruck fuer jedes Gewebe zwischenspeichern *)
          (* (als Anfangsdruck fuer naechsten Zeitschritt) *)
          p_t_ig_te_hilfe [i] := p_t_ig_te2;

          <neue Gewebesaettigung grafisch anzeigen>

          (* wird nur fuer die Ausgabe der Gewebedaten am Ende der *)
          (* Grafik-Simulation benoetigt *)
          saett_proz [i, 5] := round (saettigung_in_proz_tiefe * 100);
          saett_proz [i, 6] := round (saettigung_in_proz * 100);

          if tiefe > 0
            then
              begin
                (* Nullzeit des i-ten Gewebes *)
                zaehler := p_i_ig - p_t_tol_ig_obfl [i];
                nenner := p_i_ig - p_t_ig_te2;
                if nenner = 0.0 then nenner := 1e-20;
                zn := zaehler / nenner;
                if zn > 0.0
                  then
                    begin
                      log := ln (zn);

                      (* Mittelwert der Halbwertszeit *)
                      t1 := zh_l16 [i, 1] * p_t_ig_te2_n2;
                      t2 := zh_l16 [i, 6] * p_t_ig_te2_he;
                      p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
                      zh_l16_t12 := (t1 + t2) / p_t_ig_te2;

                      nullzeit [i] := - zh_l16_t12 * log / log2
                    end
                  else
                    nullzeit [i] := konst_null
              end
        end; (* Schleife ueber alle Gewebe *)

      (* bei zu schnellem Aufstieg, wenn die Toleranzen des Fuehrungsgewebes *)
      (* ueberschritten werden *)
      <ggf_totenkopf_warnung_ausgeben>

      (* kuerzeste Nullzeit aller Gewebe ermitteln; ist massgebend fuer den Taucher *)
      i := anzahl_beruecksichtigte_gewebe;
      while (nullzeit [i] = konst_null) and (i > 1) do dec (i);
      (* deswegen, weil kuerzeste_nullzeit <> konst_null sein muss ! *)

  (* Hier muss jetzt eine for-Schleife von hohem i herunter bis 1 *)
  (* gemacht werden. Fuer die schnellsten Gewebe (i = 1..4) koennen *)
  (* Werte < 0 berechnet werden, die "normalerweise" keine echten *)
  (* Dekozeiten verursachen, waehrend fuer die etwas langsameren *)
  (* Gewebe konst_null berechnet wird und danach erst die tatsaechlichen *)
  (* Nullzeiten berechnet werden (mathematischer Artefakt des Modells). *)
  (* Es kann aber auch passieren, dass fuer die mittleren Gewebe konst_null *)
  (* und fuer die niedrigen doch wieder eine Dekozeit berechnet wird, *)
  (* deshalb muss eine for-Schleife ueber alle niedrigeren Gewebe von i bis 1 *)
  (* programmiert werden. *)
      kuerzeste_nullzeit := nullzeit [i];
      for kk := i downto 1 do
        begin
          if (nullzeit [kk] < kuerzeste_nullzeit) and (nullzeit [kk] <> konst_null)
            then
              kuerzeste_nullzeit := nullzeit [kk]
        end;

      if kuerzeste_nullzeit > 0
        then
          begin
            erlaubte_tiefe := 0;  (* Aufstieg direkt zur Oberflaeche moeglich *)
            if dekostopp (* bei der letzten Tiefe *)
              then
                <neue (kuerzeste) Nullzeit ausgeben>
          end
        else
          if kuerzeste_nullzeit = konst_null
            then
              (* nahe der Wasseroberflaeche "unendliche" Nullzeit *)
              unendliche_nullzeit_setzen
            else
              (* Tauchgang deko-pflichtig *)
              dekostopp_berechnen
    end; (* gewebesaettigung_berechnen *)

--------------------------------------------------------------------------------

  procedure entsaettigungszeit_bei_oberflaechenintervall_985;

    begin
      (* Stickstoffteildruck im Atemgas auf der Einstiegshoehe *)
      p_i_ig := (p_atm_einstiegshoehe - p_h2o) * f_n2;

      (* Schleife ueber alle Gewebe *)
      for i := 1 to anzahl_beruecksichtigte_gewebe do
        begin
          (* Entsaettigung auf 98.5 % : 100 / 98.5 = 1.0152 *)
          zaehler := p_i_ig * 1.0152 - p_t_ig_te_hilfe [i];
          nenner := p_i_ig - p_t_ig_te_hilfe [i];
          if nenner = 0.0 then nenner := 1e-20;
          zn := 1.0 - zaehler / nenner;
          if zn > 0.0
            then
              begin
                log := ln (zn);
                nullzeit [i] := - log *  zh_l16 [i, 1] * rls / log2
              end
            else
              nullzeit [i] := konst_null
        end;

      (* laengste Entsaettigungszeit bestimmen *)
      laengste_entsaettigungszeit := nullzeit [1];
      for i := 2 to anzahl_beruecksichtigte_gewebe do
        if nullzeit [i] > laengste_entsaettigungszeit
          then
            laengste_entsaettigungszeit := nullzeit [i];

      if laengste_entsaettigungszeit <= 0.0
        then
          begin
            (* Gewebe sind bereits entsaettigt *)
            std1 := 0; min1 := 0
          end
        else
          begin
            (* Umrechnung in Stunden und Minuten *)
            std1 := round (laengste_entsaettigungszeit) div 60;
            min1 := round (laengste_entsaettigungszeit) - std1 * 60
          end
    end; (* entsaettigungszeit_bei_oberflaechenintervall_985 *)

--------------------------------------------------------------------------------

  procedure flugverbotszeit_berechnen;

    begin
      (* Fuer jedes Gewebe die Entsaettigungszeit bis zu dem Druck ermitteln, *)
      (* der als noch tolerierten niedrigeren Umgebungsdruck den bei 4200m  *)
      (* Hoehe hat (weil Kabinendruck soweit abfallen kann <nach Buehlmann-   *)
      (* Buch>) *)

      (* Der Scubapro DC-12 gibt als Flugverbotszeit die Entsaettigungszeit  *)
      (* (vermutlich 98,5 %) an. Das erscheint zunaechst sehr lang.          *)
      (* Ist aber offensichtlich doch ganz vernuenftig, da bei der in diesem *)
      (* Modell verwendeten Gleichung das Problem auftritt, dass fuer das     *)
      (* Argument des ln negative Werte auftauchen koennen (die dann nicht   *)
      (* in Betracht gezogen werden koennen). Die Flugverbotszeit wird immer *)
      (* aus dem groessten berechneten Wert ermittelt (welcher nach der       *)
      (* Gleichung noch moeglich ist !!!). Das kann dazu fuehren, dass fuer     *)
      (* einen TG eine laengere Flugverbotszeit berechnet wird, als fuer      *)
      (* einen tieferen und/oder laengeren ! Deshalb ist es auf jeden Fall   *)
      (* sicherer, die Entsaettigungszeit als Flugverbotszeit zu nehmen. Das *)
      (* gilt fuer Druecke entsprechend Hoehen oberhalb 2000m.                 *)
      (* Die Aladin-Tauchcomputer rechnen sogar mit 4800m, was zunaechst     *)
      (* noch sicherer sein sollte. Allerdings verwenden sie nicht das      *)
      (* langsamste Gewebe, sondern nur die mittelschnellen, weil die       *)
      (* bekannten Deko-Unfaelle wohl nur hierdurch verursacht werden. Das   *)
      (* nur die mittelschnellen Gewebe fuer die FVZ beruecksichtigt werden,  *)
      (* wird leider verschwiegen !                                         *)

      if werte_985_4200_4800
        then
          begin
            if hoehe_4200 then hoehenwert := 4200.0
                          else hoehenwert := 4800.0
          end
        else
          hoehenwert := 2000.0;

      (* Luftdruck in entsprechender Hoehe nach der barometrischen Hoehenformel *)
      p_amb := p_0 * exp (konst * hoehenwert);

      (* Stickstoffteildruck im Atemgas auf 4200m oder 2000m Hoehe *)
      p_i_ig_fliegen := (p_amb - p_h2o) * f_n2;

      (* Schleife ueber alle Gewebe *)
      j := 0;
      for i := 1 to anzahl_beruecksichtigte_gewebe do
        begin
          p_t_ig_te2 := p_i_ig_fliegen / zh_l16 [i, 2] + zh_l16 [i, modell];
          zaehler := p_t_ig_te2 - p_t_ig_te_hilfe [i];
          nenner := p_i_ig - p_t_ig_te_hilfe [i];
          if nenner = 0.0 then nenner := 1e-20;
          zn := 1.0 - zaehler / nenner;
          if zn > 0.0
            then
              begin
                log := ln (zn);
                nullzeit [i] := - log * zh_l16 [i, 1] * rls / log2
              end
            else
              begin
                nullzeit [i] := konst_null;
                inc (j)            (* Anzahl nicht beruecksichtigter Gewebe *)
              end;
        end;

      (* laengste Entsaettigungszeit bestimmen *)
      index_bg := 1;
      laengste_entsaettigungszeit := nullzeit [1];
      for i := 2 to anzahl_beruecksichtigte_gewebe do
        if nullzeit [i] > laengste_entsaettigungszeit
          then
            begin
              laengste_entsaettigungszeit := nullzeit [i];
              index_bg := i
            end;

      if laengste_entsaettigungszeit <= 0.0
        then
          begin
            (* keine Flugverbotszeit, da tol. Inertgasueberdruecke der Gewebe *)
            (* bei den "momentanen" Saettigungswerten nicht ueberschritten werden *)
            std2 := 0; min2 := 0;
            bestimmendes_gewebe_anzeigen := false
          end
        else
          begin
            (* Flugverbot; Umrechnung der einzuhaltenden Wartezeit *)
            (* in Stunden und Minuten *)
            std2 := round (laengste_entsaettigungszeit) div 60;
            min2 := round (laengste_entsaettigungszeit) - std2 * 60;
            bestimmendes_gewebe_anzeigen := true
          end
    end; (* flugverbotszeit_berechnen *)

--------------------------------------------------------------------------------

Prozeduren fuer die Aufstiegsprofil-Berechnung:
-----------------------------------------------

  procedure naechsten_punkt_speichern (dauer, i_tiefe : integer);

    begin
      new (z_temp);
      z2^.z := z_temp;
      z2^.dauer := dauer;
      z2^.i_tiefe := i_tiefe;
      z2 := z_temp;
      z2^.dauer := -1 (* Speicherplatz MUSS vorbelegt werden, weil sonst *)
                      (* irgendetwas da stehen kann, was unweigerlich zu *)
                      (* Problemen fuehrt ! *)
    end; (* naechsten_punkt_speichern *)

  function benoetigte_luftmenge_in_einzelschritten : double;

    var
      azv, q_ben : double;

    begin
      q_ben := 0.0;
      if aladin_tg then schritte := 20
                   else schritte := round (t_e / zeit_ink);
      p_ink := (p_amb - p_amb_alt) / schritte;
      p_hilfe := p_amb_alt;
      azv := amv * zeit_ink;          (* Atem"sekunden"volumen *)
      for i := 1 to schritte do
        begin
          p_hilfe := p_hilfe + p_ink;
          q_ben := q_ben + p_hilfe * azv
        end;
      benoetigte_luftmenge_in_einzelschritten := q_ben
    end; (* benoetigte_luftmenge_in_einzelschritten *)

  procedure neue_saettigung_berechnen;

    var
      t1, t2, t3, t_e_t12_n2, t_e_t12_he : double;

    begin
      t1 := p_amb - p_h2o;
      p_i_ig_n2 := t1 * f_n2;
      p_i_ig_he := t1 * f_he;
      p_i_ig := p_i_ig_n2 + p_i_ig_he;
      t_e_hilfe := t_e;
      for ii := 1 to anzahl_beruecksichtigte_gewebe do
        begin
          t_e_t12_n2 := t_e_hilfe / zh_l16 [ii, 1];
          t_e_t12_he := t_e_hilfe / zh_l16 [ii, 6];

          p_t_ig_t0 := p_t_ig_te_aufstieg [ii];

          (* fuer N2 *)
          (* p_t_ig_te2 := (1.0 - exp (- t_e_t12 * log2)) * (p_i_ig_n2 - p_t_ig_t0) + p_t_ig_t0 *)
          t1 := - t_e_t12_n2 * log2;
          t2 := 1.0 - exp (t1);
          t3 := p_i_ig_n2 - p_t_ig_t0;
          p_t_ig_te2_n2 := t2 * t3 + p_t_ig_t0;

          (* fuer He *)
(*          t1 := - t_e_t12_he * log2;
          t2 := 1.0 - exp (t1);
          t3 := p_i_ig_he - p_t_ig_t0;
          p_t_ig_te2_he := t2 * t3 + p_t_ig_t0; *)
          p_t_ig_te2_he := 0.0;

          (* gemittelter Koeffizient a *)
          t1 := zh_l16 [ii, modell] * p_t_ig_te2_n2;
          t2 := zh_l16 [ii, 8] * p_t_ig_te2_he;
          p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
          zh_l16_a := (t1 + t2) / p_t_ig_te2;

          (* gemittelter Koeffizient b *)
          t1 := zh_l16 [ii, 2] * p_t_ig_te2_n2;
          t2 := zh_l16 [ii, 7] * p_t_ig_te2_he;
          zh_l16_b := (t1 + t2) / p_t_ig_te2;

          p_t_tol_ig [ii] := p_amb / zh_l16_b + zh_l16_a;
          saettigung_in_proz_tiefe := p_t_ig_te2 / p_i_ig;
          if saettigung_in_proz_tiefe > 1.0
            then
              (* RLS beruecksichtigen *)
              begin
                t1 := t_e_hilfe / rls;
                t_e_t12_n2 := t1 / zh_l16 [ii, 1];
                t_e_t12_he := t1 / zh_l16 [ii, 6];

                p_t_ig_t0 := p_t_ig_te_aufstieg [ii];

                (* fuer N2 *)
                (* p_t_ig_te2 := (1.0 - exp (- t_e_t12 * log2)) * (p_i_ig_n2 - p_t_ig_t0) + p_t_ig_t0 *)
                t1 := - t_e_t12_n2 * log2;
                t2 := 1.0 - exp (t1);
                t3 := p_i_ig_n2 - p_t_ig_t0;
                p_t_ig_te2_n2 := t2 * t3 + p_t_ig_t0;

                (* fuer He *)
(*                t1 := - t_e_t12_he * log2;
                t2 := 1.0 - exp (t1);
                t3 := p_i_ig_he - p_t_ig_t0;
                p_t_ig_te2_he := t2 * t3 + p_t_ig_t0; *)
                p_t_ig_te2_he := 0.0;

                (* gemittelter Koeffizient a *)
                t1 := zh_l16 [ii, modell] * p_t_ig_te2_n2;
                t2 := zh_l16 [ii, 8] * p_t_ig_te2_he;
                p_t_ig_te2 := p_t_ig_te2_n2 + p_t_ig_te2_he;
                zh_l16_a := (t1 + t2) / p_t_ig_te2;

                (* gemittelter Koeffizient b *)
                t1 := zh_l16 [ii, 2] * p_t_ig_te2_n2;
                t2 := zh_l16 [ii, 7] * p_t_ig_te2_he;
                zh_l16_b := (t1 + t2) / p_t_ig_te2;

                p_t_tol_ig [ii] := p_amb / zh_l16_b + zh_l16_a;
                saettigung_in_proz_tiefe := p_t_ig_te2 / p_i_ig
              end;
          p_t_ig_te_aufstieg_hilfe [ii] := p_t_ig_te2;

          (* Nullzeit des ii-ten Gewebes *)
          zaehler := p_i_ig - p_t_tol_ig_obfl [ii];
          nenner := p_i_ig - p_t_ig_te2;
          if nenner = 0.0 then nenner := 1e-20;
          zn := zaehler / nenner;
          if zn > 0.0
            then
              begin
                log := ln (zn);

                (* Mittelwert der Halbwertszeit *)
                t1 := zh_l16 [ii, 1] * p_t_ig_te2_n2;
                t2 := zh_l16 [ii, 6] * p_t_ig_te2_he;
                (* p_t_ig_te2 wurde oben schon berechnet *)
                zh_l16_t12 := (t1 + t2) / p_t_ig_te2;

                nullzeit [ii] := - zh_l16_t12 * log / log2
              end
            else
              nullzeit [ii] := konst_null
        end; (* for ii := 1 to anzahl_beruecksichtigte_gewebe do *)

      (* kuerzeste Nullzeit aller Gewebe ermitteln *)
      ii := anzahl_beruecksichtigte_gewebe;
      while (nullzeit [ii] = konst_null) and (ii > 1) do dec (ii);
      kuerzeste_nullzeit := nullzeit [ii];
      for k := ii downto 1 do
        begin
          if (nullzeit [k] < kuerzeste_nullzeit) and (nullzeit [k] <> konst_null)
            then
              kuerzeste_nullzeit := nullzeit [k]
        end;

      if ((kuerzeste_nullzeit > 0) or (kuerzeste_nullzeit = konst_null))
         (* in unguenstigen Faellen kann es passieren, dass die kuerzeste Nullzeit *)
         (* noch positiv ist (und fuer einige Gewebe kein Wert berechnet werden *)
         (* konnte), obwohl vorhergehend eine groessere erlaubte Tiefe als 3m *)
         (* ermittelt wurde. In diesem Fall duerfte jetzt trotzdem bis zur Ober- *)
         (* flaeche aufgetaucht werden, was sicherlich falsch waere ! Deshalb die *)
         (* Abfrage, ob die Tiefen-Differenz nicht mehr als 3m betraegt; dann *)
         (* kann ganz aufgetaucht werden, ansonsten muss eine erneute Deko- *)
         (* berechnung durchgefuehrt werden *)
         and (erlaubte_tiefe <= 3)
        then
          erlaubte_tiefe := 0  (* Aufstieg direkt zur Oberflaeche moeglich *)
        else
          (* Dekotiefe berechnen *)
          begin
            (* noch tolerierten niedrigeren Umgebungsdruck aller Gewebe bei *)
            (* der momentanen Saettigung des jeweiligen Gewebes berechnen *)
            for ii := 1 to anzahl_beruecksichtigte_gewebe do
              begin
                (* gemittelter Koeffizient a *)
                t1 := zh_l16 [ii, modell] * p_t_ig_te2_n2;
                t2 := zh_l16 [ii, 8] * p_t_ig_te2_he;
                (* p_t_ig_te2 weiter oben schon berechnet *)
                zh_l16_a := (t1 + t2) / p_t_ig_te2;

                (* gemittelter Koeffizient b *)
                t1 := zh_l16 [ii, 2] * p_t_ig_te2_n2;
                t2 := zh_l16 [ii, 7] * p_t_ig_te2_he;
                zh_l16_b := (t1 + t2) / p_t_ig_te2;

                p_amb_tol [ii] := (p_t_ig_te_aufstieg_hilfe [ii] - zh_l16_a) * zh_l16_b
              end;

            (* maximalen Wert (= tiefste Tiefe) bestimmen (Fuehrungsgewebe) *)
            index := 1;
            max_p_amb_tol := p_amb_tol [index];
            for ii := 2 to anzahl_beruecksichtigte_gewebe do
              if max_p_amb_tol < p_amb_tol [ii]
                then
                  begin
                    max_p_amb_tol := p_amb_tol [ii];
                    index := ii
                  end;

            (* passende Deko-Stufe dazu ermitteln *)

            (* fuer max. Wert tolerierte Tiefe bestimmen *)
            tol_tiefe := (max_p_amb_tol - p_atm_einstiegshoehe) * 10.0 / dichte;

            (* Tiefe des notwendigen Deko-Stopps bestimmen *)
            (* (ab 701 m wegen groesserer Sicherheit in geringer Tauchtiefe *)
            (* "Bergsee-Dekostopp-Tiefen" anzeigen) *)
            if hoehe_einstieg <= 700 then j := 1
                                     else j := 2;
            ii := 1;
            while tol_tiefe > dekostopp_tiefen [j, ii] do inc (ii);
            erlaubte_tiefe := dekostopp_tiefen [j, ii];

            (* notwendige Deko-Zeit auf dieser Tiefe berechnen *)
            p := dichte * erlaubte_tiefe / 10.0 + p_atm_einstiegshoehe;

            zaehler := p_i_ig - p_t_tol_ig_naechst_hoehere_dekostufe (index, j, ii - 1);
            nenner := p_i_ig - p_t_ig_te_aufstieg_hilfe [index];
            if nenner = 0.0 then nenner := 1e-20;
            zn := zaehler / nenner;
            if zn > 0.0
              then
                begin
                  log := ln (zn);

                  (* Mittelwert der Halbwertszeit *)
                  t1 := zh_l16 [index, 1] * p_t_ig_te2_n2;
                  t2 := zh_l16 [index, 6] * p_t_ig_te2_he;
                  zh_l16_t12 := (t1 + t2) / p_t_ig_te2;

                  dekozeit := - zh_l16_t12 * log / log2 + 1.0
                  (* 1.0 wird addiert, weil spaeter auf volle Minuten abgeschnitten *)
                  (* wird und so sichergestellt wird, dass mindestens 1 Minute *)
                  (* dekomprimiert wird *)
                end
              else
                (* in diesen Zweig duerfte das Programm nie laufen *)
                erlaubte_tiefe := 0
          end
    end; (* neue_saettigung_berechnen *)

  procedure schnellst_moeglicher_aufstieg_bis_oberflaeche_oder_dekostufe;

    var
      diff_tiefe, nen, erlaubte_tiefe_alt : integer;
      absolute_dekostufe_erreicht : boolean;

    begin
      absolute_dekostufe_erreicht := false;
      repeat
        (* erlaubte Aufstiegsgeschwindigkeit berechnen *)
        (* ab jetzt (1.2.2000) nur noch langsamere Aufstiegsgeschwindigkeiten erlaubt *)
        if (erlaubte_tiefe >= 10) then nen := 10  (* bis 10m -> 10m/min *)
                                  else nen := 5;  (* ab 9m -> 5m/min *)

        diff_tiefe := i_tiefe - erlaubte_tiefe;
        if diff_tiefe mod nen = 0 then t_e := diff_tiefe div nen
                                  else t_e := round (diff_tiefe / nen + 0.5);

        if erlaubte_tiefe >= 3
          then
            (* direkter Aufstieg zur Oberflaeche nicht erlaubt *)
            begin
              erlaubte_tiefe_alt := erlaubte_tiefe;
              p_amb := dichte * erlaubte_tiefe / 10.0 + p_atm_einstiegshoehe;
              neue_saettigung_berechnen;  (* fuer Aufstiegsphase *)
              absolute_dekostufe_erreicht := erlaubte_tiefe_alt = erlaubte_tiefe;
              if absolute_dekostufe_erreicht and (t_e > 0.0)
                then
                  (* Gewebe entsaettigen sich beim Aufstieg nicht so viel, *)
                  (* dass noch weiter aufgetaucht werden koennte; jetzt *)
                  (* koennen Daten gespeichert werden. *)
                  (* Aber nur, wenn auch die zweite Bedingung erfuellt ist; *)
                  (* das ist zur Zeit noch ein kleiner Artefakt des Algorithmus. *)
                  (* Es kann passieren, dass noch weiter auf der Dekostufe verweilt *)
                  (* werden muss (wird auch im folgenden richtig gerechnet), dann *)
                  (* darf jetzt aber nicht q berechnet und der Punkt abgespeichert werden. *)
                  begin
                    inc (dauer_aufstieg, round (t_e));
                    q_benoetigt_aufstieg := benoetigte_luftmenge_in_einzelschritten + q_benoetigt_aufstieg;
                    naechsten_punkt_speichern (dauer_aufstieg, erlaubte_tiefe);
                    p_amb_alt := p_amb
                  end
            end
          else
            (* direkter Aufstieg zur Oberflaeche ist moeglich *)
            begin
              if hoehe_einstieg <= 700
                then
                  (* zunaechst Sicherheitsstopp von 3 Minuten Dauer in 3m Tiefe einlegen *)
                  begin
                    if erlaubte_tiefe_alt > erlaubte_tiefe
                      then
                        (* Luftverbrauch fuer den Aufstieg und die Zeit dafuer beruecksichtigen *)
                        begin
                          inc (dauer_aufstieg, round (t_e));
                          naechsten_punkt_speichern (dauer_aufstieg, 3);
                          p_amb := dichte * 0.3 + p_atm_einstiegshoehe;

                          (* Luftverbrauch Aufstieg *)
                          q_benoetigt_aufstieg := benoetigte_luftmenge_in_einzelschritten + q_benoetigt_aufstieg
                        end;
                    (* wenn schon durch Dekostopp auf 3m Tiefe verweilt wurde, *)
                    (* koennen die Sicherheits-3-Minuten sofort angehaengt werden *)

                    (* Luftverbrauch fuer 3 Minuten auf 3m Tiefe *)
                    q_benoetigt_aufstieg := p_amb * amv * 3.0 + q_benoetigt_aufstieg;
                    inc (dauer_aufstieg, 3);
                    naechsten_punkt_speichern (dauer_aufstieg, 3)
                  end
                else
                  (* zunaechst Sicherheitsstopp von 2 Minuten Dauer in 4m Tiefe einlegen *)
                  begin
                    if erlaubte_tiefe_alt > erlaubte_tiefe
                      then
                        (* Luftverbrauch fuer den Aufstieg und die Zeit dafuer beruecksichtigen *)
                        begin
                          inc (dauer_aufstieg, round (t_e));
                          naechsten_punkt_speichern (dauer_aufstieg, 4);
                          p_amb := dichte * 0.4 + p_atm_einstiegshoehe;

                          (* Luftverbrauch Aufstieg *)
                          q_benoetigt_aufstieg := benoetigte_luftmenge_in_einzelschritten + q_benoetigt_aufstieg
                        end;
                    (* wenn schon durch Dekostopp auf 4m Tiefe verweilt wurde, *)
                    (* koennen die Sicherheits-2-Minuten sofort angehaengt werden *)

                    (* Luftverbrauch fuer 2 Minuten auf 4m Tiefe *)
                    q_benoetigt_aufstieg := p_amb * amv * 2.0 + q_benoetigt_aufstieg;
                    inc (dauer_aufstieg, 2);
                    naechsten_punkt_speichern (dauer_aufstieg, 4);

                    (* jetzt noch Sicherheitsstopp von 2 Minuten Dauer in 2m Tiefe *)
                    inc (dauer_aufstieg);   (* Aufstieg von 4m auf 2m Tiefe *)
                    naechsten_punkt_speichern (dauer_aufstieg, 2);
                    p_amb := dichte * 0.2 + p_atm_einstiegshoehe;

                    (* Luftverbrauch Aufstieg *)
                    q_benoetigt_aufstieg := benoetigte_luftmenge_in_einzelschritten + q_benoetigt_aufstieg;

                    (* Luftverbrauch fuer 2 Minuten auf 2m Tiefe *)
                    q_benoetigt_aufstieg := p_amb * amv * 2.0 + q_benoetigt_aufstieg;
                    inc (dauer_aufstieg, 2);
                    naechsten_punkt_speichern (dauer_aufstieg, 2)
                  end;

              (* Luftverbrauch beim Aufstieg aus 3m Tiefe in 1 Minute zur Oberflaeche *)
              t_e := 1.0;
              p_amb_alt := p_amb;
              p_amb := p_atm_einstiegshoehe;
              q_benoetigt_aufstieg := benoetigte_luftmenge_in_einzelschritten + q_benoetigt_aufstieg;
              inc (dauer_aufstieg);
              naechsten_punkt_speichern (dauer_aufstieg, 0);

              absolute_dekostufe_erreicht := true;
              oberflaeche_erreicht := true
            end
      until absolute_dekostufe_erreicht;
      i_tiefe := erlaubte_tiefe
    end; (* schnellst_moeglicher_aufstieg_bis_oberflaeche_oder_dekostufe *)

  procedure vgz_bei_aufstieg_zur_oberflaeche_berechnen;

    var
      vorlaeufige_vgz : integer;
      potenz, delta_vgz, sub : byte;
      dekrementiert, inkrementiert, konvergenz_erreicht : boolean;
      p1_amb, t_e1, p_amb_alt_hilfe, q_veratmet_aufstieg : double;

    procedure aufstiegsprofil_berechnen;

      begin
        (* Speicherplatz des vorigen Aufstieg-Profils loeschen *)
        if speicherplatz_allokiert_2 then liste_2_freigeben;
        new (wurzel_2);
        z2 := wurzel_2;
        z2^.dauer := -1; (* Speicherplatz MUSS vorbelegt werden, weil sonst *)
                         (* irgendetwas da stehen kann, was unweigerlich zu *)
                         (* Problemen fhrt ! *)
        speicherplatz_allokiert_2 := true;

        p_amb := p1_amb;
        p_amb_alt := p_amb_alt_hilfe;
        dauer_aufstieg := dauer;
        i_tiefe := t1;

        (* Phase auf gleicher Tiefe *)
        (* Gewebesaettigung bis zum Beginn des Aufstiegs berechnen *)
        for ii := 1 to 16 do p_t_ig_te_aufstieg [ii] := p_t_ig_te_hilfe [ii];
        t_e := vorlaeufige_vgz;
        neue_saettigung_berechnen;
        (* Luftverbrauch auf gleichbleibender Tiefe *)
        q_benoetigt_aufstieg := p_amb * amv * t_e;

        (* Ende der Grundzeit speichern *)
        inc (dauer_aufstieg, vorlaeufige_vgz);
        naechsten_punkt_speichern (dauer_aufstieg, i_tiefe);

        (* Aufstiegsphase *)
        oberflaeche_erreicht := false;
        repeat
          for ii := 1 to 16 do p_t_ig_te_aufstieg [ii] := p_t_ig_te_aufstieg_hilfe [ii];
          schnellst_moeglicher_aufstieg_bis_oberflaeche_oder_dekostufe;
          if not oberflaeche_erreicht
            then
              (* Halt auf Dekostufe *)
              begin
                t_e := round (dekozeit + 0.5);  (* aufrunden *)
                for ii := 1 to 16 do p_t_ig_te_aufstieg [ii] := p_t_ig_te_aufstieg_hilfe [ii];
                inc (dauer_aufstieg, round (t_e));
                naechsten_punkt_speichern (dauer_aufstieg, erlaubte_tiefe);
                neue_saettigung_berechnen;
                (* Luftverbrauch auf Dekostufe *)
                q_benoetigt_aufstieg := p_amb * amv * t_e + q_benoetigt_aufstieg
              end
        until oberflaeche_erreicht;

        (* gesamt verbrauchte Luftmenge *)
        q_veratmet_aufstieg := q_veratmet_hilfe + q_benoetigt_aufstieg;
                               (* gesamt bisher tatsaechlich verbrauchte Luftmenge *)
                                                  (* fuer Aufstieg von momentaner Tiefe *)

        (* verbleibender Restdruck in bar in der Flasche *)
        p_flasche := round ((q_anfang - q_veratmet_aufstieg) / v)
      end; (* aufstiegsprofil_berechnen *)

    begin  (* vgz_bei_aufstieg_zur_oberflaeche_berechnen *)
      p_amb_alt_hilfe := p_amb_alt; (* muessen am Ende     *)
      p1_amb := p_amb;              (* dieser Prozedur    *)
      t1 := i_tiefe;                (* wieder restauriert *)
      t_e1 := t_e;                  (* werden             *)
      vorlaeufige_vgz := 16;        (* willkuerlich vorgegeben *)
      potenz := 4;                  (* 2^4 = 16 *)
      dekrementiert := false;
      inkrementiert := false;
      konvergenz_erreicht := false;
      luftvorrat_erschoepft := false;
      reserve_angegriffen := false;
      repeat
        aufstiegsprofil_berechnen;
        konvergenz_erreicht := (p_flasche = p_reserve) or (potenz = 0) or
                               (reserve_angegriffen and (p_flasche = 0));
        if not konvergenz_erreicht
          then
            (* je nach Restdruck in der Flasche vgz verlaengern oder verkuerzen *)
            begin
              delta_vgz := 1;
              for ii := 1 to potenz - 2 do delta_vgz := delta_vgz * 2;
              if (p_flasche > p_reserve) or (reserve_angegriffen and (p_flasche > 0))
                then
                  (* Grundzeit verlaengern *)
                  begin
                    if dekrementiert
                      then
                        vorlaeufige_vgz := vorlaeufige_vgz + delta_vgz
                      else
                        begin
                          inc (potenz, 2);  (* 2, da unten auf jeden Fall dekrementiert wird *)
                          inc (vorlaeufige_vgz, vorlaeufige_vgz)
                        end;
                    inkrementiert := true
                  end
                else
                  (* Grundzeit verkuerzen *)
                  begin
                    if dekrementiert or inkrementiert
                      then
                        vorlaeufige_vgz := vorlaeufige_vgz - delta_vgz
                      else
                        begin
                          vorlaeufige_vgz := 2 * delta_vgz;
                          inc (potenz)  (* darf jetzt nicht dekrementiert werden, was *)
                                        (* aber 4 Zeilen tiefer auf jeden Fall passiert *)
                        end;
                    dekrementiert := true
                  end;
              dec (potenz)
            end
          else
            begin
              (* Konvergenz ist erreicht; zur Vorsicht pruefen, ob - falls *)
              (* Potenz = 0 - bei der letzten Potenz-Dekrementierung durch *)
              (* erneute Verlaengerung der vgz um 1 Minute nicht doch die *)
              (* Reserve angebrochen wurde und die vgz deshalb wieder um *)
              (* 1 Minute verkuerzt und das Aufstiegsprofil noch einmal neu *)
              (* berechnet werden muss *)
              luftvorrat_erschoepft := p_flasche < p1_amb;
              if ((not reserve_angegriffen) and (potenz = 0) and (p_flasche < p_reserve)) or
                 (reserve_angegriffen and luftvorrat_erschoepft (* and ((potenz = 0) or (potenz = 1) *) )
                then
                  begin
                    if vorlaeufige_vgz > 0 then begin
                                                  dec (vorlaeufige_vgz);
                                                  aufstiegsprofil_berechnen
                                                end;
                    if reserve_angegriffen
                      then
                        begin
                          luftvorrat_erschoepft := p_flasche < p1_amb;
                          (* true, wenn kein nutzbarer Luftvorrat mehr vorhanden *)
                          (* (Der Druck in der Flasche kann max. herunter bis zum *)
                          (* Umgebungsdruck genutzt werden !) *)
                          while luftvorrat_erschoepft and (vorlaeufige_vgz > 0) do
                            begin
                              dec (vorlaeufige_vgz);
                              aufstiegsprofil_berechnen;
                              luftvorrat_erschoepft := p_flasche < p1_amb
                            end
                        end
                      else
                        if (p_flasche < p_reserve)
                          then
                            (* normaler Luftvorrat erschoepft, *)
                            (* Reserve muss angegriffen werden *)
                            begin
                              vorlaeufige_vgz := 16;   (* muessen *)
                              potenz := 4;             (* jetzt  *)
                              dekrementiert := false;  (* neu vorgegeben *)
                              inkrementiert := false;  (* werden *)
                              konvergenz_erreicht := false;
                              reserve_angegriffen := true
                            end
                  end
            end
      until konvergenz_erreicht or luftvorrat_erschoepft;
      p_amb_alt := p_amb_alt_hilfe;
      p_amb := p1_amb;
      i_tiefe := t1;
      t_e := t_e1;
      vgz := vorlaeufige_vgz;
      if not luftvorrat_erschoepft then aufstiegsprofil_zeichnen
    end; (* vgz_bei_aufstieg_zur_oberflaeche_berechnen *)

